/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.localization;

import com.badlogic.gdx.Gdx;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.localization.AchievementStrings;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.localization.CharacterStrings;
import com.megacrit.cardcrawl.localization.CreditStrings;
import com.megacrit.cardcrawl.localization.EventStrings;
import com.megacrit.cardcrawl.localization.KeywordStrings;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.localization.PotionStrings;
import com.megacrit.cardcrawl.localization.PowerStrings;
import com.megacrit.cardcrawl.localization.RelicStrings;
import com.megacrit.cardcrawl.localization.TutorialStrings;
import com.megacrit.cardcrawl.localization.UIStrings;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LocalizedStrings {
    private static final Logger logger = LogManager.getLogger(LocalizedStrings.class.getName());
    private static final String LOCALIZATION_DIR = "localization";
    private static Map<String, MonsterStrings> monsters;
    private static Map<String, PowerStrings> powers;
    private static Map<String, CardStrings> cards;
    private static Map<String, RelicStrings> relics;
    private static Map<String, EventStrings> events;
    private static Map<String, PotionStrings> potions;
    private static Map<String, CreditStrings> credits;
    private static Map<String, TutorialStrings> tutorials;
    private static Map<String, KeywordStrings> keywords;
    private static Map<String, CharacterStrings> characters;
    private static Map<String, UIStrings> ui;
    private static Map<String, AchievementStrings> achievements;

    public LocalizedStrings() {
        String langPackDir;
        long startTime = System.currentTimeMillis();
        Gson gson = new Gson();
        switch (Settings.language) {
            case CHINESE_SIMPLIFIED: {
                langPackDir = LOCALIZATION_DIR + File.separator + "zhs";
                break;
            }
            case CHINESE_TRADITIONAL: {
                langPackDir = LOCALIZATION_DIR + File.separator + "zht";
                break;
            }
            case ENGLISH: {
                langPackDir = LOCALIZATION_DIR + File.separator + "eng";
                break;
            }
            case FRENCH: {
                langPackDir = LOCALIZATION_DIR + File.separator + "fra";
                break;
            }
            case GERMAN: {
                langPackDir = LOCALIZATION_DIR + File.separator + "deu";
                break;
            }
            case JAPANESE: {
                langPackDir = LOCALIZATION_DIR + File.separator + "jpn";
                break;
            }
            case KOREAN: {
                langPackDir = LOCALIZATION_DIR + File.separator + "kor";
                break;
            }
            case RUSSIAN: {
                langPackDir = LOCALIZATION_DIR + File.separator + "rus";
                break;
            }
            case WWW: {
                langPackDir = LOCALIZATION_DIR + File.separator + "www";
                break;
            }
            default: {
                langPackDir = LOCALIZATION_DIR + File.separator + "www";
            }
        }
        String monsterPath = langPackDir + File.separator + "monsters.json";
        Type monstersType = new TypeToken<Map<String, MonsterStrings>>(){}.getType();
        monsters = (Map)gson.fromJson(LocalizedStrings.loadJson(monsterPath), monstersType);
        String powerPath = langPackDir + File.separator + "powers.json";
        Type powerType = new TypeToken<Map<String, PowerStrings>>(){}.getType();
        powers = (Map)gson.fromJson(LocalizedStrings.loadJson(powerPath), powerType);
        String cardPath = langPackDir + File.separator + "cards.json";
        Type cardType = new TypeToken<Map<String, CardStrings>>(){}.getType();
        cards = (Map)gson.fromJson(LocalizedStrings.loadJson(cardPath), cardType);
        String relicPath = langPackDir + File.separator + "relics.json";
        Type relicType = new TypeToken<Map<String, RelicStrings>>(){}.getType();
        relics = (Map)gson.fromJson(LocalizedStrings.loadJson(relicPath), relicType);
        String eventPath = langPackDir + File.separator + "events.json";
        Type eventType = new TypeToken<Map<String, EventStrings>>(){}.getType();
        events = (Map)gson.fromJson(LocalizedStrings.loadJson(eventPath), eventType);
        String potionPath = langPackDir + File.separator + "potions.json";
        Type potionType = new TypeToken<Map<String, PotionStrings>>(){}.getType();
        potions = (Map)gson.fromJson(LocalizedStrings.loadJson(potionPath), potionType);
        String creditPath = langPackDir + File.separator + "credits.json";
        Type creditType = new TypeToken<Map<String, CreditStrings>>(){}.getType();
        credits = (Map)gson.fromJson(LocalizedStrings.loadJson(creditPath), creditType);
        String tutorialsPath = langPackDir + File.separator + "tutorials.json";
        Type tutorialType = new TypeToken<Map<String, TutorialStrings>>(){}.getType();
        tutorials = (Map)gson.fromJson(LocalizedStrings.loadJson(tutorialsPath), tutorialType);
        String keywordsPath = langPackDir + File.separator + "keywords.json";
        Type keywordsType = new TypeToken<Map<String, KeywordStrings>>(){}.getType();
        keywords = (Map)gson.fromJson(LocalizedStrings.loadJson(keywordsPath), keywordsType);
        String characterPath = langPackDir + File.separator + "characters.json";
        Type characterType = new TypeToken<Map<String, CharacterStrings>>(){}.getType();
        characters = (Map)gson.fromJson(LocalizedStrings.loadJson(characterPath), characterType);
        String uiPath = langPackDir + File.separator + "ui.json";
        Type uiType = new TypeToken<Map<String, UIStrings>>(){}.getType();
        ui = (Map)gson.fromJson(LocalizedStrings.loadJson(uiPath), uiType);
        String achievePath = langPackDir + File.separator + "achievements.json";
        Type achieveType = new TypeToken<Map<String, AchievementStrings>>(){}.getType();
        achievements = (Map)gson.fromJson(LocalizedStrings.loadJson(achievePath), achieveType);
        logger.info("Loc Strings load time: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    public PowerStrings getPowerStrings(String powerName) {
        return powers.get(powerName);
    }

    public MonsterStrings getMonsterStrings(String monsterName) {
        return monsters.get(monsterName);
    }

    public EventStrings getEventString(String eventName) {
        return events.get(eventName);
    }

    public PotionStrings getPotionString(String potionName) {
        return potions.get(potionName);
    }

    public CreditStrings getCreditString(String creditName) {
        return credits.get(creditName);
    }

    public TutorialStrings getTutorialString(String tutorialName) {
        return tutorials.get(tutorialName);
    }

    public KeywordStrings getKeywordString(String keywordName) {
        return keywords.get(keywordName);
    }

    public CharacterStrings getCharacterString(String characterName) {
        return characters.get(characterName);
    }

    public UIStrings getUIString(String uiName) {
        return ui.get(uiName);
    }

    public AchievementStrings getAchievementString(String achievementName) {
        return achievements.get(achievementName);
    }

    public CardStrings getCardStrings(String cardName) {
        return cards.get(cardName);
    }

    public RelicStrings getRelicStrings(String relicName) {
        return relics.get(relicName);
    }

    private static String loadJson(String jsonPath) {
        return Gdx.files.internal(jsonPath).readString(String.valueOf(StandardCharsets.UTF_8));
    }
}

